/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class SmartInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public SmartInternalFrameTitlePane(JInternalFrame f2) {
        super(f2);
    }

    public void paintPalette(Graphics g2) {
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = null;
        Color frameColor = null;
        if (JTattooUtilities.isFrameActive(this)) {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
            backColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[10];
            frameColor = ColorHelper.darker(AbstractLookAndFeel.getWindowTitleColorDark(), 15.0);
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
            backColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
            frameColor = ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveTitleColorDark(), 15.0);
        }
        g2.setColor(frameColor);
        g2.drawLine(0, height - 1, width, height - 1);
        int dx = 8;
        int dy = 2;
        int dw = width - this.buttonsWidth - 16;
        Graphics2D g2D = (Graphics2D)g2;
        Composite composite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
        g2D.setComposite(alpha);
        float dc1 = 50.0f;
        float dc2 = 5.0f;
        Color c1 = ColorHelper.brighter(backColor, dc1);
        Color c2 = null;
        while (dy + 2 < height) {
            c2 = ColorHelper.darker(backColor, dc2);
            dc2 += 5.0f;
            g2.setColor(c1);
            g2.drawLine(dx, dy, dx + dw, dy);
            g2.setColor(c2);
            g2.drawLine(dx, ++dy, dx + dw, dy);
            dy += 2;
        }
        g2D.setComposite(composite);
    }

    public void paintBackground(Graphics g2) {
        int dx;
        int dw;
        boolean leftToRight;
        int xOffset;
        Graphics2D g2D = (Graphics2D)g2;
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = null;
        Color frameColor = null;
        if (JTattooUtilities.isActive(this)) {
            backColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[10];
            frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
        } else {
            backColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
            frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
        }
        int iconWidth = 0;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            iconWidth = icon.getIconWidth() + 5;
        }
        int titleWidth = 0;
        String frameTitle = this.frame.getTitle();
        if (frameTitle != null) {
            g2.setFont(this.getFont());
            FontMetrics fm = JTattooUtilities.getFontMetrics(this, g2, this.getFont());
            titleWidth = fm.stringWidth(JTattooUtilities.getClippedText(this.frame.getTitle(), fm, this.getWidth() - iconWidth - this.buttonsWidth - 15)) + 10;
        }
        int n2 = xOffset = (leftToRight = JTattooUtilities.isLeftToRight(this.frame)) ? iconWidth + 10 + titleWidth : width - 10 - iconWidth - titleWidth;
        if (leftToRight) {
            dw = width - this.buttonsWidth - xOffset - 10;
            dx = xOffset;
        } else {
            dw = xOffset - this.buttonsWidth - 10;
            dx = this.buttonsWidth + 10;
        }
        int dy = 3;
        if (!AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() && !AbstractLookAndFeel.getTheme().isCenterWindowTitleOn() && dw > 0) {
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            float dc1 = 50.0f;
            float dc2 = 5.0f;
            Color c1 = ColorHelper.brighter(backColor, dc1);
            Color c2 = null;
            while (dy + 5 < height) {
                c2 = ColorHelper.darker(backColor, dc2);
                dc2 += 5.0f;
                g2.setColor(c1);
                g2.drawLine(dx, dy, dx + dw, dy);
                g2.setColor(c2);
                g2.drawLine(dx, ++dy, dx + dw, dy);
                dy += 3;
            }
            g2D.setComposite(composite);
        }
        g2.setColor(frameColor);
        g2.drawLine(0, height - 1, width, height - 1);
    }

    public void paintBorder(Graphics g2) {
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        if (this.isActive()) {
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(titleColor) > 164) {
                g2.setColor(Color.black);
                JTattooUtilities.drawString(this.frame, g2, title, x + 1, y);
            }
            g2.setColor(titleColor);
            JTattooUtilities.drawString(this.frame, g2, title, x, y - 1);
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.frame, g2, title, x, y - 1);
        }
    }
}

